' Description
' -----------
' This is the code that accompanies an article I wrote for the
' December/January 1993/1994 edition of 'Visual Basic Programmer's Journal'.
'
' It is a demonstration program showing how to create custom mouse pointers
' in VB 3.0 without using a Dynamic Link Library (DLL).  Cursor.bas is a
' reusable module that you can add easily to any project.
'
' The article explains how the code works and how to create the icons that
' are used to make the cursors.
'
'
' What's new as of 1/22/95
' ------------------------
' Made adjustments to compensate for problems that occur with some video drivers
' in certain modes:
' 1) Replaced references to the icon's ScaleWidth and ScaleHeight with a constant.
' 2) When checking for the hot-spot, use a range of red colors.
'
'
' E-Mail
' ------
' America Online: MikeStanly    (Via Internet: mikestanly@aol.com)
' CompuServe:     74632,2227
'
'
' Mike Stanley
' Independent Consultant
' New Hampshire
' USA

Global Const PXLS = 3
Global Const RED_1 = &HF0&
Global Const RED_2 = &HFF&
Global Const GCW_HCURSOR = -12
Global Const GWW_HINSTANCE = -6
Global Const BITS_OFFSET = 12
Global Const ICON_SIZE = 32

Type CursorInfo
     hWnd       As Integer
     hOldCursor As Integer
     hNewCursor As Integer
End Type

Declare Function GlobalLock& Lib "Kernel" (ByVal hMem%)
Declare Function GlobalUnLock% Lib "Kernel" (ByVal hMem%)
Declare Function CreateCursor% Lib "User" (ByVal hinst%, ByVal xHotSpot%, ByVal yHotSpot%, ByVal nWidth%, ByVal nHeight%, ByVal lpvANDPlane As Any, ByVal lpvXORPlane As Any)
Declare Function DestroyCursor% Lib "User" (ByVal hcur%)
Declare Function GetWindowWord% Lib "User" (ByVal hWnd%, ByVal nIndex%)
Declare Function SetClassWord% Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal wNewWord%)
Declare Function GetPixel& Lib "GDI" (ByVal hDC%, ByVal nXPos%, ByVal nYPos%)

Function ChangeCursor (ByVal hWnd As Integer, hCursor As Integer)
    
    ChangeCursor = SetClassWord(hWnd, GCW_HCURSOR, hCursor)

End Function

Sub FindHotSpot (CursorPic As Control, x As Integer, y As Integer)
    
Dim PixelColor As Long

    For x = 0 To (ICON_SIZE - 1)
	For y = 0 To (ICON_SIZE - 1)
	    PixelColor = GetPixel(CursorPic.hDC, x, y)
	    If (PixelColor >= RED_1) And (PixelColor <= RED_2) Then Exit Sub
	Next y
    Next x

    x = 0: y = 0

End Sub

Sub MakeCursor (ByVal hWnd As Integer, picCursor As Control, picMask As Control, ciCursor As CursorInfo)

Dim x As Integer, y As Integer
				

    picCursor.AutoRedraw = True
    picCursor.ScaleMode = PXLS
    picMask.ScaleMode = PXLS
    
    FindHotSpot picCursor, x, y
    
    ciCursor.hWnd = hWnd
    ciCursor.hNewCursor = CreateCursor(GetWindowWord(hWnd, GWW_HINSTANCE), x, y, ICON_SIZE, ICON_SIZE, GlobalLock(picCursor.Picture) + BITS_OFFSET, GlobalLock(picMask.Picture) + BITS_OFFSET)
    ciCursor.hOldCursor = ChangeCursor(hWnd, ciCursor.hNewCursor)
    
    z% = GlobalUnLock(picCursor.Picture)
    z% = GlobalUnLock(picMask.Picture)
    picCursor.AutoRedraw = False

End Sub

Sub RestoreCursor (ciCursor As CursorInfo)
    
    z% = ChangeCursor(ciCursor.hWnd, ciCursor.hOldCursor)
    z% = DestroyCursor(ciCursor.hNewCursor)

End Sub

